%Peak detection and calculating Heart Beat Rate Using Discrete Wavelet
%Transform 

clear;
close all;
clc;
tic
%Eliminate Baseline Drift
t = xlsread('vf2.xls');
t1 = t(:,2);
s1=t1;
s2=smooth(s1,150); % smooths data by using the no. of data points specified by using moving average filter
ecgsmooth=s1-s2;
%%%apply Wavelet Transform
[C,L]=wavedec(ecgsmooth,8,'db4'); %returns wavelet decomposition of the signal at level 8
[d1,d2,d3,d4,d5,d6,d7,d8]=detcoef(C,L,[1,2,3,4,5,6,7,8]); %extracts the details coefficients at levels 1 to 8
%%%Denoise 
%[THR,SORH,KEEPAPP,CRIT] = ddencmp(IN1,IN2,X) returns default values for
%de-noising or compression, using wavelets or wavelet packets, of an input vector or matrix X,
%which can be a one- or two-dimensional signal. THR is the threshold, 
%SORH is for soft or hard thresholding, KEEPAPP allows you to keep approximation coefficients,
% and CRIT (used only for wavelet packets) is the entropy name
%IN1 is 'den' for de-noising or 'cmp' for compression.
%IN2 is 'wv' for wavelet or 'wp' for wavelet packet.
%[THR,SORH,KEEPAPP] = ddencmp(IN1,'wv',X) returns default values for
%de-noising (if IN1 = 'den') or compression (if IN1 = 'cmp') of X

[thr,sorh,keepapp]=ddencmp('den','wv',ecgsmooth); % wavelet denoising of the signal
cleanecg=wdencmp('gbl',C,L,'db4',8,thr,sorh,keepapp);

%thresholding
t2=cleanecg;
%plot(t2);
signal=t2;
threshold=thr;
%threshold=0.5;
%disp(threshold);

% Display for direct comparision%%%
data_vector=signal;

local_peaks = [];
peak_indices = [];

local_min = [];
min_indices = [];

size_vec = size(data_vector);
if( min(size_vec) ~= 1)
    disp(' Give a one dimensional vector');
    return;
end

bin_vec = data_vector > threshold;
temp_vec = bin_vec(2:length(bin_vec)) - bin_vec(1:length(bin_vec)-1);

start_positions = 1 + find(temp_vec  == 1);
stop_positions = 1 + find( temp_vec == -1);

% check for the first position
if (bin_vec(1) == 1)
    start_positions = [1 start_positions(:)'];
    stop_positions = stop_positions(:)';
else
    start_positions = start_positions(:)';
    stop_positions = [1 stop_positions(:)'];
end

% ignore the first bit if its negative
if (start_positions(1) > stop_positions(1))
    stop_positions = stop_positions(2:length(stop_positions));
end

% ignore the last bit
if (start_positions(length(start_positions)) > stop_positions(length(stop_positions)))
    stop_positions = [stop_positions length(bin_vec)];
end

% Now check for each part between a start and a stop to find the maxima
for part_index = 1:length(start_positions)
    [temp_max, temp_ind] = max(data_vector( start_positions(part_index):stop_positions(part_index)));
    local_peaks = [local_peaks temp_max];
    peak_indices = [peak_indices temp_ind+start_positions(part_index)-1];
end
    

% Now check for each part between a stop and a start to find the minima
for part_index = 1:min(length(stop_positions), length(start_positions))-1
    [temp_min, temp_ind] = min(data_vector( stop_positions(part_index):start_positions(part_index+1)));
    local_min = [local_min temp_min];
    min_indices = [min_indices temp_ind+stop_positions(part_index)-1];
end

% plot(bin_vec);
hold on;
plot(data_vector, 'g');
plot(peak_indices, local_peaks,'r*');
box on ;
grid on;
xlabel('Time');
ylabel('Voltage');
%disp (peak_indices); %uncomment this to get the index values for the peaks
axis([0 length(data_vector) min(data_vector)-.5 max(data_vector)+.5])

%%%thresholding1
%max_value=max(cleanecg);
%mean_value=mean(cleanecg);
%threshold=(max_value-mean_value)/2;
%disp(threshold);

%%%R detection algorithm %%%%%%%%%
a5=appcoef(C,L,'db4',5);
C1=[a5;d5;d4;d3];
L1=[length(a5);length(d5);length(d4);length(d3);length(cleanecg)];
R_detect_signal=waverec(C1,L1,'db4');
R_detect_squared=R_detect_signal.^2;

%%%Beat_Rate_Extraction_Algorithm %%%%%%%%%
for a=1:length(R_detect_squared)
    if R_detect_squared(a)>threshold
        R_detect_new(a)=R_detect_squared(a);
    else
        R_detect_new(a)=0;
    end
end
mean_R_detect=5*mean(R_detect_new);
for q=1:length( R_detect_new)-1
    if  R_detect_new(q)< mean_R_detect
        R_detect_new(q)=0;
    end

end
%%%%%%%%%%%%%%%%%%
d=0;
for b=1:length( R_detect_new)-1
        if ( R_detect_new(b)==0) & ( R_detect_new(b+1)~=0)
        d=d+1;
        indext(d)= b+1;
        end
end
fs_R_deetect=length(R_detect_new)/20;
time=indext.*1/fs_R_deetect;
ind=0;
for z=1:length(time)-1
    ind=ind+1;
    time_diff(ind)=time(z+1)-time(z);
end
av_time=mean(time_diff);
Square_Number=av_time/.2;
beat_Rate=300/Square_Number;
high=max(R_detect_new);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%Plot the Orginal Signal and Eliminating Baseline Drift signal
figure;
hold on;
subplot(411);plot(s1);title('Orginal Signal');
subplot(412);plot(s1-s2);title('Baseline drift Elimination');
subplot(413);plot(cleanecg);title('Main Signal');
subplot(414);plot(data_vector);hold on;
subplot(414);plot(peak_indices, local_peaks,'r*');title('R detected Signal');
%subplot(414);plot(R_detect_new);
text(length(R_detect_new)/2,high,['Beat Rate = ',num2str(fix(beat_Rate))],'EdgeColor','red');
toc